package com.vn.wifitest.utils;

import java.util.ArrayList;
import java.util.List;

import com.vn.wifitest.R;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiManager.WifiLock;
import android.util.Log;
import android.widget.Toast;

public class WifiAdmin {
    // 定义WifiManager对象   
    private WifiManager mWifiManager;  
    // 定义WifiInfo对象     
    private WifiInfo mWifiInfo;    
    // 扫描出的网络连接列表     
    private List<ScanResult> mWifiList;    
    // 网络连接列表     
    private List<WifiConfiguration> mWifiConfiguration;    
    // 定义一个WifiLock     
    WifiLock mWifiLock;  
   
    // 构造器     
    public WifiAdmin(Context context) {    
        // 取得WifiManager对象     
        mWifiManager = (WifiManager) context    
                .getSystemService(Context.WIFI_SERVICE);    
        // 取得WifiInfo对象     
        mWifiInfo = mWifiManager.getConnectionInfo();    
    }    
  
    // 打开WIFI   
    public void openWifi(Context context) {  
        if (!mWifiManager.isWifiEnabled()) {  
            mWifiManager.setWifiEnabled(true);
        }else if (mWifiManager.getWifiState() == 2) {
    		Toast.makeText(context,context.getString(R.string.info_wifi_opend), Toast.LENGTH_SHORT).show();
		}else{
        	Toast.makeText(context,context.getString(R.string.info_wifi_opend), Toast.LENGTH_SHORT).show();
        }
    }  
  
    // 关闭wifi
    public void closeWifi(Context context) {    
        if (mWifiManager.isWifiEnabled()) {    
            mWifiManager.setWifiEnabled(false);    
        }else if(mWifiManager.getWifiState() == 1){  
            Toast.makeText(context,context.getString(R.string.info_wifi_closed), Toast.LENGTH_SHORT).show();  
        }else if (mWifiManager.getWifiState() == 0) {  
            Toast.makeText(context,context.getString(R.string.info_wifi_closed), Toast.LENGTH_SHORT).show();  
        }else{  
            Toast.makeText(context,context.getString(R.string.info_wifi_closed_again), Toast.LENGTH_SHORT).show();  
        }  
    }    
    
    // 检查当前WIFI状态     
    public void checkState(Context context) {    
        if (mWifiManager.getWifiState() == 0) {  
            Toast.makeText(context,context.getString(R.string.wifi_closing), Toast.LENGTH_SHORT).show();  
        } else if (mWifiManager.getWifiState() == 1) {  
            Toast.makeText(context,context.getString(R.string.wifi_closed), Toast.LENGTH_SHORT).show();  
        } else if (mWifiManager.getWifiState() == 2) {  
            Toast.makeText(context,context.getString(R.string.wifi_opening), Toast.LENGTH_SHORT).show();  
        } else if (mWifiManager.getWifiState() == 3) {  
            Toast.makeText(context,context.getString(R.string.wifi_opened), Toast.LENGTH_SHORT).show();  
        } else {  
            Toast.makeText(context,context.getString(R.string.no_wifi_state), Toast.LENGTH_SHORT).show();  
        }    
    }    
    
    // 锁定WifiLock     
    public void acquireWifiLock() {  
        mWifiLock.acquire();  
    }  
  
    // 解锁WifiLock     
    public void releaseWifiLock() {    
        // 判断时候锁定     
        if (mWifiLock.isHeld()) {    
            mWifiLock.acquire();    
        }    
    }    
    
    // 创建一个WifiLock     
    public void creatWifiLock() {    
        mWifiLock = mWifiManager.createWifiLock("Test");    
    }    
    
    // 得到配置好的网络     
    public List<WifiConfiguration> getConfiguration() {    
        return mWifiConfiguration;    
    }    
    
    // 指定配置好的网络进行连接     
    public void connectConfiguration(int index) {    
        // 索引大于配置好的网络索引返回     
        if (index > mWifiConfiguration.size()) {    
            return;    
        }    
        // 连接配置好的指定ID的网络     
        mWifiManager.enableNetwork(mWifiConfiguration.get(index).networkId,    
                true);    
    }    
  
    public void startScan(Context context) {  
        mWifiManager.startScan();  
        //得到扫描结果   
    	List<ScanResult> results = mWifiManager.getScanResults();   
    	// 得到配置好的网络连接   
	mWifiConfiguration = mWifiManager.getConfiguredNetworks();   
	if (results == null) {  
		if(mWifiManager.getWifiState()==3){  
		    	Toast.makeText(context,context.getString(R.string.no_wifi),Toast.LENGTH_SHORT).show();  
        	}else if(mWifiManager.getWifiState()==2){  
            		Toast.makeText(context,context.getString(R.string.wifi_opening), Toast.LENGTH_SHORT).show();  
        	}else{
			Toast.makeText(context,context.getString(R.string.wifi_not_open), Toast.LENGTH_SHORT).show();  
       		}  
	} else {
		mWifiList = new ArrayList();
	    	for(ScanResult result : results){
	    		if (result.SSID == null || result.SSID.length() == 0
	    				|| result.capabilities.contains("[IBSS]")) {
	    			continue;
	    		}
	    		boolean found = false;
	    		Log.i("MainActivity","result= "+result.SSID +" capabilities= "+result.capabilities);
	    		for(ScanResult item:mWifiList){
	    			Log.i("MainActivity","item= "+item.SSID +" capabilities="+item.capabilities);
	    			if(item.SSID.equals(result.SSID)&&item.capabilities.equals(result.capabilities)){
	    				Log.i("MainActivity","found true");
	    				found = true;
	    				break;
	    			}
	    		}
	    		if(!found){
	    			mWifiList.add(result);
	    		}
	    	}
	    }
    }  
  
    // 得到网络列表   
    public List<ScanResult> getWifiList() {  
        return mWifiList;  
    }  
  
    // 查看扫描结果   
    public StringBuilder lookUpScan() {  
        StringBuilder stringBuilder = new StringBuilder();  
        for (int i = 0; i < mWifiList.size(); i++) {  
            stringBuilder  
                    .append("Index_" + new Integer(i + 1).toString() + ":");  
            // 将ScanResult信息转换成一个字符串包     
            // 其中把包括：BSSID、SSID、capabilities、frequency、level    
            stringBuilder.append((mWifiList.get(i)).toString());  
            stringBuilder.append("/n");  
        }  
        return stringBuilder;  
    } 
  
    // 得到MAC地址  
    public String getMacAddress() {  
        return (mWifiInfo == null) ? "NULL" : mWifiInfo.getMacAddress();  
    }  
  
    // 得到接入点的BSSID   
    public String getBSSID() {  
        return (mWifiInfo == null) ? "NULL" : mWifiInfo.getBSSID();  
    }  
  
    // 得到连接的IP  
    public int getIPAddress() {  
        return (mWifiInfo == null) ? 0 : mWifiInfo.getIpAddress();  
    }  
  
    // 得到连接的ID   
    public int getNetworkId() {  
        return (mWifiInfo == null) ? 0 : mWifiInfo.getNetworkId();  
    }  
  
    // 得到WifiInfo的所有信息包   
    public String getWifiInfo() {  
        return (mWifiInfo == null) ? "NULL" : mWifiInfo.toString();  
    }  
  
    // 添加一个网络并连接   
    public void addNetwork(WifiConfiguration wcg) {  
     int wcgID = mWifiManager.addNetwork(wcg);  
     boolean b =  mWifiManager.enableNetwork(wcgID, true);  
     System.out.println("a--" + wcgID); 
     System.out.println("b--" + b); 
    }  
  
    // 断开指定ID的网络   
    public void disconnectWifi(int netId) {  
        mWifiManager.disableNetwork(netId);  
        mWifiManager.disconnect();  
    }
    public void removeWifi(int netId) {
        disconnectWifi(netId);
        mWifiManager.removeNetwork(netId);
    }
  
//创建wifi热点的。
  
    public WifiConfiguration CreateWifiInfo(String SSID, String Password, int Type)  
    {  
          WifiConfiguration config = new WifiConfiguration();    
           config.allowedAuthAlgorithms.clear();  
           config.allowedGroupCiphers.clear();  
           config.allowedKeyManagement.clear();  
           config.allowedPairwiseCiphers.clear();  
           config.allowedProtocols.clear();  
           config.SSID = "\"" + SSID + "\"";    
           
          WifiConfiguration tempConfig = this.IsExsits(SSID);            
          if(tempConfig != null) {   
              mWifiManager.removeNetwork(tempConfig.networkId);   
          } 
           
          if(Type == 1) //WIFICIPHER_NOPASS 
          {  
               config.wepKeys[0] = "";  
               config.allowedKeyManagement.set(WifiConfiguration.KeyMgmt.NONE);  
               config.wepTxKeyIndex = 0;  
          }  
          if(Type == 2) //WIFICIPHER_WEP 
          {  
              config.hiddenSSID = true; 
              config.wepKeys[0]= "\""+Password+"\"";  
              config.allowedAuthAlgorithms.set(WifiConfiguration.AuthAlgorithm.SHARED);  
              config.allowedGroupCiphers.set(WifiConfiguration.GroupCipher.CCMP);  
              config.allowedGroupCiphers.set(WifiConfiguration.GroupCipher.TKIP);  
              config.allowedGroupCiphers.set(WifiConfiguration.GroupCipher.WEP40);  
              config.allowedGroupCiphers.set(WifiConfiguration.GroupCipher.WEP104);  
              config.allowedKeyManagement.set(WifiConfiguration.KeyMgmt.NONE);  
              config.wepTxKeyIndex = 0;  
          }  
          if(Type == 3) //WIFICIPHER_WPA 
          {  
          config.preSharedKey = "\""+Password+"\"";  
          config.hiddenSSID = true;    
          config.allowedAuthAlgorithms.set(WifiConfiguration.AuthAlgorithm.OPEN);    
          config.allowedGroupCiphers.set(WifiConfiguration.GroupCipher.TKIP);                          
          config.allowedKeyManagement.set(WifiConfiguration.KeyMgmt.WPA_PSK);                          
          config.allowedPairwiseCiphers.set(WifiConfiguration.PairwiseCipher.TKIP);                     
          //config.allowedProtocols.set(WifiConfiguration.Protocol.WPA);   
          config.allowedGroupCiphers.set(WifiConfiguration.GroupCipher.CCMP); 
          config.allowedPairwiseCiphers.set(WifiConfiguration.PairwiseCipher.CCMP); 
          config.status = WifiConfiguration.Status.ENABLED;    
          } 
           return config;  
    }  
     
    private WifiConfiguration IsExsits(String SSID)   
    {   
        List<WifiConfiguration> existingConfigs = mWifiManager.getConfiguredNetworks();   
           for (WifiConfiguration existingConfig : existingConfigs)    
           {   
             if (existingConfig.SSID.equals("\""+SSID+"\""))   
             {   
                 return existingConfig;   
             }   
           }   
        return null;    
    } 
}